/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api.c															
*																			
* Project, Target, subsystem:	SST 6.0, Stubs, API
* 
* Created:						11.03.2007														
*
* Modified:						07.06.2007										
*
* \Author						Raviv levi														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "sst_key_management.h"
#include "sst_host_op_code.h"


/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/
 /*Key management services        */

/*SST_AESKeyInsert*/
DxError_t SST_AESKeyInsert(SSTTxnId_t         aTransactionId,
                            SSTSessionId_t     aSessionId,
                            SSTHandle_t        aInitialCtrlAuth,  
                            DxByte_t          *aKey_ptr,
                            SSTAESKeyType_t    aKeyType,
							SSTDataType_t      aDataType,
                            SSTHandle_t       *aKeyHandle_ptr,
							DxByte_t          *aWorkspace_ptr,
                            DxUint32_t		  aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_AES_INSERT, 10,
	   							 /* PARAMETERS: */
                                aTransactionId,
                                aSessionId,
                                aInitialCtrlAuth,  
                                aKey_ptr,
                                aKeyType,
                                aDataType,
                                aKeyHandle_ptr,
                                aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}


/*SST_AESKeyGenerate*/
DxError_t SST_AESKeyGenerate(SSTTxnId_t       aTransactionId,
                             SSTSessionId_t   aSessionId,
                             SSTHandle_t      aInitialCtrlAuth,                                
                             SSTAESKeyType_t  aKeyType,
							 SSTDataType_t    aDataType,
                             SSTHandle_t     *aKeyHandle_ptr,
							 DxByte_t       *aWorkspace_ptr,
                             DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_AES_GEN, 9,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,
                                 aInitialCtrlAuth,                                
                                 aKeyType,
                                 aDataType,
                                 aKeyHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*SST_AESKeyRead*/
DxError_t SST_AESKeyRead(SSTSessionId_t     aSessionId,
                          SSTHandle_t        aKeyHandle,   
                          DxByte_t          *aKey_ptr,
                          SSTAESKeyType_t   *aKeyType_ptr,
						  DxByte_t			*aWorkspace_ptr,
                          DxUint32_t		aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_AES_READ, 7,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aKeyHandle,   
                                  aKey_ptr,
                                  aKeyType_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}



/*SST_DESKeyInsert*/
DxError_t SST_DESKeyInsert(SSTTxnId_t          aTransactionId,
                            SSTSessionId_t     aSessionId,
                            SSTHandle_t        aInitialCtrlAuth,
                            DxByte_t          *aKey_ptr,
                            SSTDESKeyType_t    aKeyType,
							SSTDataType_t      aDataType,
                            SSTHandle_t       *aKeyHandle_ptr,
							DxByte_t		  *aWorkspace_ptr,
                            DxUint32_t         aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_DES_INSERT, 10,
	   							 /* PARAMETERS: */
                                aTransactionId,
                                aSessionId,
                                aInitialCtrlAuth,
                                aKey_ptr,
                                aKeyType,
                                aDataType,
                                aKeyHandle_ptr,
                                aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}



/*SST_DESKeyGenerate*/
DxError_t SST_DESKeyGenerate(SSTTxnId_t         aTransactionId,
                             SSTSessionId_t     aSessionId,                           
                             SSTHandle_t        aInitialCtrlAuth,   
                             SSTDESKeyType_t    aKeyType,
							 SSTDataType_t      aDataType,
                             SSTHandle_t       *aKeyHandle_ptr,
							 DxByte_t		   *aWorkspace_ptr,
                             DxUint32_t         aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_DES_GEN, 9,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,                           
                                 aInitialCtrlAuth,   
                                 aKeyType,
                                 aDataType,
                                 aKeyHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*SST_DESKeyRead*/
DxError_t SST_DESKeyRead(SSTSessionId_t      aSessionId,
                          SSTHandle_t        aKeyHandle,
                          DxByte_t          *aKey_ptr,
                          SSTDESKeyType_t   *aKeyType_ptr,
						  DxByte_t			*aWorkspace_ptr,
                          DxUint32_t		 aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_DES_READ, 7,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aKeyHandle,
                                  aKey_ptr,
                                  aKeyType_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}



/*SST_HMACKeyInsert*/
DxError_t SST_HMACKeyInsert(SSTTxnId_t      aTransactionId,                             
                             SSTSessionId_t  aSessionId,
                             SSTHandle_t     aInitialCtrlAuth,   
                             DxByte_t       *aKey_ptr,
                             DxUint32_t      aKeySizeInBytes,
							 SSTDataType_t    aDataType,
                             SSTHandle_t    *aKeyHandle_ptr,
							 DxByte_t       *aWorkspace_ptr,
                             DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_HMAC_INSERT, 10,
	   							 /* PARAMETERS: */
                                 aTransactionId,                             
                                 aSessionId,
                                 aInitialCtrlAuth,   
                                 aKey_ptr,
                                 aKeySizeInBytes,
                                 aDataType,
                                 aKeyHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}


/*SST_HMACKeyGenerate*/
DxError_t SST_HMACKeyGenerate(SSTTxnId_t      aTransactionId,
                               SSTSessionId_t  aSessionId,                             
                               SSTHandle_t     aInitialCtrlAuth,   
                               DxUint32_t      aKeySizeInBytes,
							   SSTDataType_t   aDataType,
                               SSTHandle_t    *aKeyHandle_ptr,
							   DxByte_t       *aWorkspace_ptr,
							   DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_HMAC_GEN, 9,
	   							 /* PARAMETERS: */
                                   aTransactionId,
                                   aSessionId,                             
                                   aInitialCtrlAuth,   
                                   aKeySizeInBytes,
                                   aDataType,
                                   aKeyHandle_ptr,
                                   aWorkspace_ptr,
                                   aWorkspaceSizeInBytes );
}



/*SST_HMACKeyRead*/
DxError_t SST_HMACKeyRead(SSTSessionId_t  aSessionId,
                           SSTHandle_t     aKeyHandle,
                           DxByte_t       *aKey_ptr,
                           DxUint32_t     *aKeysizeInBytes,
						   DxByte_t       *aWorkspace_ptr,
                           DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_HMAC_READ, 7,
	   							 /* PARAMETERS: */
                                   aSessionId,
                                   aKeyHandle,
                                   aKey_ptr,
                                   aKeysizeInBytes,
                                   aWorkspace_ptr,
                                   aWorkspaceSizeInBytes );
}



/*_DX_SST_RSAKeyInsert*/
DxError_t _DX_SST_RSAKeyInsert(SSTTxnId_t      aTransactionId,
                                SSTSessionId_t  aSessionId,
                                SSTHandle_t     aInitialCtrlAuth, 
								SSTRSAKeyType_t aKeyType,
                                DxUint8_t      *aN_ptr,
                                DxUint32_t      aNsizeInBytes,
                                DxUint8_t      *aD_ptr,
                                DxUint32_t      aDsizeInBytes,
                                DxUint8_t      *aE_ptr, 
                                DxUint32_t      aEsizeInBytes,
                                SSTDataType_t   aDataType,
                                SSTHandle_t    *aKeyHandle_ptr,
								DxByte_t       *aWorkspace_ptr,
                                DxUint32_t      aWorkspaceSizeInBytes)
{
    
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_RSA_INSERT, 15,
	   							 /* PARAMETERS: */
                                aTransactionId,
                                aSessionId,
                                aInitialCtrlAuth, 
								aKeyType,
                                aN_ptr,
                                aNsizeInBytes,
                                aD_ptr,
                                aDsizeInBytes,
                                aE_ptr, 
                                aEsizeInBytes,
                                aDataType,
                                aKeyHandle_ptr,
								aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}



/*SST_RSAKeyGenerate*/
DxError_t SST_RSAKeyGenerate(SSTTxnId_t      aTransactionId,
                             SSTSessionId_t  aSessionId,
                             SSTHandle_t     aInitialCtrlAuth,  
                             DxUint32_t      aNsizeInBytes,
                             DxByte_t       *aE_ptr,                                     
                             DxUint32_t      aEsizeInBytes,
							 SSTDataType_t   aDataType,
                             SSTHandle_t    *aKeyHandle_ptr,
							 DxByte_t       *aWorkspace_ptr,
							 DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_RSA_GEN, 11,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,
                                 aInitialCtrlAuth,  
                                 aNsizeInBytes,
                                 aE_ptr,                                     
                                 aEsizeInBytes,
                                 aDataType,
                                 aKeyHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*_DX_SST_RSAKeyRead*/
DxError_t _DX_SST_RSAKeyRead(SSTSessionId_t aSessionId,  
                            SSTHandle_t     aKeyHandle, 
							SSTRSAKeyType_t aKeyType,
                            DxUint8_t      *aN_ptr,
                            DxUint32_t     *aNsizeInBytes_ptr,
                            DxUint8_t      *aD_ptr,
                            DxUint32_t     *aDsizeInBytes_ptr,
                            DxUint8_t      *aE_ptr,
                            DxUint32_t     *aEsizeInBytes_ptr,
							DxByte_t       *aWorkspace_ptr,
                            DxUint32_t      aWorkspaceSizeInBytes)
{
  
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_RSA_READ, 12,
	   							 /* PARAMETERS: */
                                aSessionId,  
                                aKeyHandle, 
                                aKeyType,
                                aN_ptr,
                                aNsizeInBytes_ptr,
                                aD_ptr,
                                aDsizeInBytes_ptr,
                                aE_ptr,
                                aEsizeInBytes_ptr,
                                aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}



/*_DX_SST_CRTRSAKeyInsert*/
DxError_t _DX_SST_CRTRSAKeyInsert(SSTTxnId_t    aTransactionId,
								SSTSessionId_t  aSessionId,
								SSTHandle_t     aInitialCtrlAuth, 
								SSTRSAKeyType_t aKeyType,
								DxByte_t		*aN_ptr,
								DxUint32_t      aNsizeInBytes,
								DxByte_t       *aE_ptr,
								DxUint32_t      aEsizeInBytes,
								DxByte_t       *aP_ptr,
								DxUint32_t      aPsizeInBytes,
								DxByte_t       *aQ_ptr,
								DxUint32_t      aQsizeInBytes,
								DxByte_t       *aDP_ptr,
								DxUint32_t      aDPsizeInBytes,
								DxByte_t       *aDQ_ptr,
								DxUint32_t      aDQsizeInBytes,
								DxByte_t       *aQinv_ptr,
								DxUint32_t      aQinvsizeInBytes,
								SSTDataType_t   aDataType,
								SSTHandle_t    *aKeyHandle_ptr,
								DxByte_t       *aWorkspace_ptr,
								DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_CRTRSA_INSERT, 23,
	   							 /* PARAMETERS: */
                                aTransactionId,
								aSessionId,
								aInitialCtrlAuth, 
								aKeyType,
								aN_ptr,
								aNsizeInBytes,
								aE_ptr,
								aEsizeInBytes,
								aP_ptr,
								aPsizeInBytes,
								aQ_ptr,
								aQsizeInBytes,
								aDP_ptr,
								aDPsizeInBytes,
								aDQ_ptr,
								aDQsizeInBytes,
								aQinv_ptr,
								aQinvsizeInBytes,
								aDataType,
								aKeyHandle_ptr,
								aWorkspace_ptr,
								aWorkspaceSizeInBytes );
}



/*SST_CRTRSAKeyGenerate*/
DxError_t SST_CRTRSAKeyGenerate(SSTTxnId_t      aTransactionId,
                                SSTSessionId_t  aSessionId,
                                SSTHandle_t     aInitialCtrlAuth, 
                                DxUint32_t      aKeysizeInBytes,
                                DxByte_t       *aE_ptr,
                                DxUint32_t      aEsizeInBytes,
								SSTDataType_t   aDataType,
                                SSTHandle_t    *aKeyHandle_ptr,
								DxByte_t       *aWorkspace_ptr,
								DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_CRTRSA_GEN, 11,
	   							 /* PARAMETERS: */
                                aTransactionId,
                                aSessionId,
                                aInitialCtrlAuth, 
                                aKeysizeInBytes,
                                aE_ptr,
                                aEsizeInBytes,
								aDataType,
                                aKeyHandle_ptr,
								aWorkspace_ptr,
								aWorkspaceSizeInBytes );
}


/*_DX_SST_CRTRSAKeyRead*/
DxError_t _DX_SST_CRTRSAKeyRead(SSTSessionId_t  aSessionId,
								SSTHandle_t     aKeyHandle,
								SSTRSAKeyType_t aKeyType,
								DxByte_t		*aN_ptr,
								DxUint32_t     *aNsizeInBytes_ptr,
								DxByte_t       *aE_ptr,
								DxUint32_t     *aEsizeInBytes_ptr,
								DxByte_t       *aP_ptr,
								DxUint32_t     *aPsizeInBytes_ptr,
								DxByte_t       *aQ_ptr,
								DxUint32_t     *aQsizeInBytes_ptr,
								DxByte_t       *aDP_ptr,
								DxUint32_t     *aDPsizeInBytes_ptr,
								DxByte_t       *aDQ_ptr,
								DxUint32_t     *aDQsizeInBytes_ptr,
								DxByte_t       *aQinv_ptr,
								DxUint32_t     *aQinvsizeInBytes_ptr,
								DxByte_t       *aWorkspace_ptr,
								DxUint32_t      aWorkspaceSizeInBytes)
{
   
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_KM_CRTRSA_READ, 20,
	   							 /* PARAMETERS: */
                                aSessionId,
								aKeyHandle,
								aKeyType,
								aN_ptr,
								aNsizeInBytes_ptr,
								aE_ptr,
								aEsizeInBytes_ptr,
								aP_ptr,
								aPsizeInBytes_ptr,
								aQ_ptr,
								aQsizeInBytes_ptr,
								aDP_ptr,
								aDPsizeInBytes_ptr,
								aDQ_ptr,
								aDQsizeInBytes_ptr,
								aQinv_ptr,
								aQinvsizeInBytes_ptr,
								aWorkspace_ptr,
								aWorkspaceSizeInBytes );
}

